# --------------------------
# --------------------------
# Figure 3: Edge/area ratio v VMR
# --------------------------
# --------------------------

rootDirectory = '' # YOU must set this!

rdaInputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 2 & S1 - Pareto optimum figure/RDA', sep = '')
figureOutputDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Figures 2 & S1 - Pareto optimum figure', sep = '')
functionDirectory = paste(rootDirectory,'/Scripts & model output Fivash et al 2021 JAppEcol/Functions', sep = '')
source(paste(functionDirectory,'callFunctions.R', sep = ''))
callFunctions(functionDirectory)

library(raster)

setwd(rdaInputDirectory)
load('Figure2_trials.rda')
load('Figure2_grids.rda')

VMR = data$VMR

# --- Determine colors ------

col = alpha(colorRampPalette(c('blue','red'))(1000),0.5)
VMRColSeq = exp(seq(log(min(VMR)), log(max(VMR)), length.out = 1000))
colIndex = rep(NA, times = length(VMR))
for(i_matrix in 1:length(VMR)){
  colIndex[i_matrix] = which.min(abs(VMR[i_matrix] - VMRColSeq))
}

# --------
# Calculate edge/area ratio
# --------
edgeArea.ratio = c()
for(i_grid in 1:dim(MiSeries)[3]){
  M = MiSeries[,,i_grid]
  edge = edgeFind(M)
  edgeArea.ratio[i_grid] = sum(edge)/sum(M)
}

# --------
# Plot Figure 3 - main panel
# --------

tiff('Figure3_mainPanel.tiff', width = 2300, height = 2400, res = 300)
par(mar = c(5,5,4,4))
plot(edgeArea.ratio ~ VMR, log = 'x', bty = 'n',
     pch = '.', col = col[colIndex], cex = 5, cex.lab = 1.5, cex.axis = 1.4,
     xlim = c(0.1,100), ylim = c(0.01,1),
     ylab = 'Edge/area ratio', xlab = 'Variance-to-mean ratio (VMR)')
dev.off()


# --------
# Plot Figure 3 - subpanels
# --------

colEdge = c(terrain.colors(n = 100)[100],terrain.colors(n = 100)[1],terrain.colors(n = 100)[70])
VMRSeq = exp(seq(log(0.166), log(72), length.out = 8))
par(mfrow = c(1,1))
par(mar = c(5,5,4,4))
setwd(figureOutputDirectory)
tiff('Figure3_subPanels_%04d.tif',  width = 20, height = 20, units = 'cm', res = 300)
for(i in 1:(length(VMRSeq) - 1)){
  i_grid = sample(which(VMR > VMRSeq[i] & VMR < VMRSeq[i + 1]), size = 1)
  
  M = MiSeries[,,i_grid]
  
  edge = edgeFind(M)
  M_edge = M
  M_edge[M == 1] = M[M == 1] + edge[M == 1]
  plot(raster(M_edge), col = colEdge, legend = F, box = F, axes = F, zlim = c(0,2), main = paste(VMR[i_grid],',',i_grid))
  
}
dev.off()